{COMMENT:
ASCII FILE FOR CALIBRATION OF WFM601i INSTRUMENTS

CODE KEY (See PRC_LANG.DOC for instruction on building MODEL,
            OPTION, and TITLE codes from the key.

        01    ALL STEPS, ALL STANDARDS

        10    MISC STEPS (MAIN BOARD)
        20    COMPONENT BOARD
        40    DESERIALIZER BOARD
        80    EYE PATTERN BOARD}

{MODEL:
TEK_WFM601I    F1}

{OPTIONS:
FULL            FF
COMPONENT       2F
DESERIALIZER    4F
EYE_PATTERN     8F}

{VERSION:
V1.1}

{COMMENT:   BEGIN STEPS HERE}

{TITLE:00:FACTORY PRESET INITIALIZATION}

{SETUP:

a.  Remove all signals and terminators.}

{INST_STATE:
IN:SOU SERIALA

IN:CHAN CH1

EY:DISP OVERLAY

EY:JIT J1000

IN:PBPROFFS MV_350

FILT FLAT

GAIN:W_V_STATE X1

GAIN:WFM:VAR:STATE OFF

GAIN:WFM:CAL OFF

GAIN:VEC:VAR:STATE OFF

GAIN:LTNG:VAR:VERT:STATE OFF

GAIN:LTNG:VAR:HORZ:STATE OFF

SWEEP:TIMING TWOL

SWEEP:MAG OFF

REF:MODE INT

LINES:MODE OFF

LINES:FIELD ALL

LINES:NUMBER:LINES_525 23

LINES:NUMBER:LINES_625 23

LINES:DISP H1

DISP:MULTIPLE WFM,VECTOR

DISP:SINGLE WFM

CUR:SEL VOLT

CUR:SEL NONE

LTNG:GRAT LTNG

VEC:BARS B100

STAND AUTO

ROTEST OFF

CALS:EN OFF

SER:DISP YPBPR

SER:MON GBR

SER:EAVSAV STRIP

SER:AL:MISSINGVID AL

SER:AL:FFCRC AL

SER:AL:APCRC AL

SER:AL:FMTERROR AL

SER:AL:MONGA OFF

SER:AL:SCREENGA AL

MENU CLEAR

PRE:STORE FACTORY}

{PROCEDURE:

a.  The instrument Factory Preset has been initialized.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:POWER SUPPLY ADJUSTMENT AND CHECKS}

{SETUP:

a.  Remove all signals and terminators.}

{INST_STATE:
PRE:RE FACTORY}

{PROCEDURE:

a.  Connect the voltmeter to A1W1 (dummy resistor marked +5V on
        the Power Supply board).

b.  ADJUST - A1R73 (Power Supply board) for +5.00 V +/- 0.1 V.

c.  Connect the voltmeter to A1W3 (dummy resistor marked +11V on
        the Power Supply board) and check for +11 V +/- 1.0 V.

d.  Connect the voltmeter to A1W2 (dummy resistor marked -11V on
        the Power Supply board) and check for -11 V +/- 1.0 V.

e.  Connect the voltmeter to the Primary side of A1R69 (resistor
        marked +40V on the Power Supply board) and check for +40 V
        +/- 5 V.

f.  Connect the voltmeter to the Power Supply board side of A3C73
        (located by the RED crt deflection lead on the Main board)
        and check for +100 V +/- 5.0 V.

g.  Connect the voltmeter to A3U78 Pin 3 (Main board) and check for
        +8 V +/- 0.5 V.

h.  Connect the voltmeter to A3U53 Pin 3 (Main board) and check
        for -8 V +/- 0.5 V.

i.  Connect the voltmeter to the -8 Volt test point
        (A5 Deserializer board) and check for -8 V +/- 0.5 V.

j.  Connect the voltmeter to the +8 Volt test point
        (A5 Deserializer board) and check for +8 V +/- 0.5 V.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:41:PARALLEL CLOCK}

{SETUP:

a.  Connect the serial digital output of the television
        signal generator to the WFM 601i SER A input.
        Terminate the loopthrough with a 75 ohm high-frequency
        terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect a X1 probe from the frequency counter to A5TP1
        (Deserializer board).  Connect the probe ground to A5TP2.

d.  Set the frequency counter attenuation to X1, coupling to AC, and
        the gate to 0.1 second.}

{INST_STATE:
PRE:RE FACTORY}

{PROCEDURE:

a.  CHECK - that the frequency counter readout is 27 MHz.

b.  Select the SER B input, or remove the signal from the SER A
        input.

c.  ADJUST - A5R18 (VCO ADJ) for 26.5 MHz. (+/- 0.25 MHz).

d.  Select the SER A input or reconnect the signal to the SER A
        input.

e.  CHECK - that the frequency counter readout is 27 MHz and the
        WFM 601i display is stable.

f.  Remove the probe and ground clip from the test points.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:41:SERIAL OUTPUT}

{SETUP:

a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input. Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect a 75 ohm cable from the WFM 601i SERIAL OUT to an
        oscilloscope through a 75 ohm feed-through terminator.

d.  Set the oscilloscope to 200 mV/div. and 50 ns/div.
       Turn on the X10 horizontal mag, and set the input bandwidth
       to full.}

{INST_STATE:
PRE:RE FACTORY}

{PROCEDURE:

a.  CHECK - that the displayed signal on oscilloscope is 800 mV
        +/- 10% (2 minor divisions).

b.  MOVE - A5J3 (Deserializer board) to pins 2-3 (740 mV position).

c.  CHECK - that the displayed signal on oscilloscope is 740 mV
        +/- 10% (2 minor divisions).

d.  MOVE - A5J4 (Deserializer board) to pins 1-2 (800 mV position).

e.  Turn off the oscilloscope X10 horizontal mag.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:DAC OSCILLATOR}

{SETUP:

a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.
        Terminate the loopthrough with a 75 ohm high-frequency
        terminator.

b.  Set the generator signal output for the PAL shallow ramp signal.

c.  Connect a X1 probe to the frequency counter.  Set the counter
       for X1 attenuation, AC coupling, and 0.1 second gate.}

{INST_STATE:
PRE:RE FACTORY
GAIN:W_V_STATE X10
DISP:SINGLE PAR
INPUT:PBPROFFS MV_0
INPUT:CHAN CH1,CH2,CH3}

{PROCEDURE:

a.  Connect the 1X probe to A8R94 (DAC Board); connect to the side
        of the resistor closest to the heat sink.

b.  ADJUST - the counter trigger for a stable readout.

c.  ADJUST - A8R1 for a readout of 102.5 kHz, +/- 1 kHz, on the
        frequency counter.

d.  CHECK - for no noise on the signal baselines of CH2 and CH3.

e.  Set the television signal generator for NTSC output.

f.  CHECK - for no noise on the signal baselines of CH2 and CH3.

g.  Repeat this step at least once, adjusting A8R1 for no noise on
        the CH2 and CH3 signal baselines, in both NTSC and PAL
        standards, while keeping the frequency readout within range
        (102.5 kHz +/- 1 kHz).

h.  Set the television signal generator for PAL output.

i.  Disconnect the 1X probe from A8R94.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:FULL BIT CHECK}

{SETUP:

a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.
        Terminate the loopthrough with a 75 ohm high-frequency
        terminator.

b.  Set the generator signal output for the shallow ramp signal.}

{INST_STATE:
PRE:RE FACTORY
IN:CHAN CH1,CH2,CH3
GAIN:W_V_STATE X5
DISP:SINGLE PAR
SWEEP:TIMING ONEL}

{PROCEDURE:

a.  CHECK - for smooth lines with no gaps or bumps on the ramp
        displays; use the Vertical Position bezel control to view
        the entire signal.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:EXTERNAL REFERENCE INPUT CHECK}

{INST_STATE:
PRE:RE FACTORY
IN:SOU SERIALB}

{SETUP:

a.  To the WFM 601i SER B input, connect the serial digital output
        of the television signal generator.
        Terminate the loopthrough with a 75 ohm high-frequency
        terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect the BLACK output of the television signal generator to
        the WFM 601i EXT REF input.  Terminate the loopthrough in 75
        ohms.}


{PROCEDURE:

a.  CHECK - that the display stays locked while switching between
        internal and external reference (front panel).

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:CRT VERTICAL GAIN}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE PAR
IN:CHAN CH1,CH2,CH3
GAIN:W_V_STATE X10}

{SETUP:

a.  Connect the serial digital output of the television
        signal generator to the WFM 601i SER A input.
        Terminate the loopthrough with a 75 ohm high-frequency
        terminator.

b.  Set the generator signal output to the 100% sweep signal.

c.  Connect a X10 probe from the oscilloscope to the Primary side of
        A1R69 (resistor marked +40V on the Power Supply board).

d.  Set the oscilloscope to 5 V/div., and 2 ms/div.}

{PROCEDURE:

a.  Position the CH2 and CH3 signal baselines to the WFM 601i
        graticule baseline.

b.  Reference the dc voltage (+40V signal) on the oscilloscope to
        the center graticule line.

c.  Move the oscilloscope probe to the blue CRT deflection lead on
       the Main board.

d.  ADJUST - A3R182 (Main board) for signal amplitude that is 2.5 V
        (1/2 major division) less than the 40 Volt reference
        amplitude noted in step b.

e.  Move the oscilloscope probe to the brown CRT deflection lead on
        the Main board.

f.  CHECK - for signal amplitude that is within +/- 2 V of the
        amplitude on the blue deflection lead.

g.  Disconnect the scope probe from the brown CRT deflection lead.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:READOUT INTENSITY AND FOCUS}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE WFM
DISP:INTENSITY:READ -2047
SER:AL:SCREENGA OFF
DISP:FOCUS:NORM 0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
DISPLAY:INTENSITY:MINVIS   READOUT MIN}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Be careful to change only the WFM 601i
        settings and controls called out in this step.  This step
        overwrites the Factory Preset settings stored in the Preset
        menu, and exiting this step before completing it may cause
        the instrument to be incorrectly calibrated.

b.  ADJUST - A1R53 (Power Supply board) to just turn off the bright
        dot in the top left readout.

c.  Enter the CRT menu (front panel).

d.  ADJUST - READOUT MIN (PC) to make the readout just visible and
        readable.

e.  Select READOUT (CRT menu) and adjust READOUT INTENSITY (second
        bezel knob from the right) for normal readout intensity.
        NOTE: The readout will go blank when READOUT is selected.

f.  ADJUST - A1R9 and A1R44 (Power Supply board) for the best
        focused text.

g.  ADJUST - A3R134 and A3R135 (Main board) for best readout
         character display.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
DISP:SINGLE WFM
MENU CLEAR
SER:AL:SCREENGA AL
PRE:STORE FACTORY}

{END}

{TITLE:11:TRACE ROTATION, Y ALIGNMENT, AND GEOMETRY}

{INST_STATE:
PRE:RE FACTORY
CUR:SEL TIME}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Be careful to change only the WFM 601i
        settings and controls called out in this step.  This step
        overwrites the Factory Preset settings stored in the Preset
        menu, and exiting this step before completing it may cause
        the instrument to be incorrectly calibrated.

b.  Position the TIME2 marker (bezel knob) to the center of the
        graticule.

c.  Enter the CRT menu and select TRACE.

d.  Adjust TRACE ROTATE (bezel knob) to align the TIME2 marker with
        the two horizontal center graticule tick marks.
        The Adjustment Procedure section of the Service Manual
        includes a figure of this display.

e.  ADJUST - A3R168 (Main board) so that the signal baseline is
        parallel with the graticule baseline.

f.  Select 2 FIELD sweep.  Enter the Gain menu and select X5.

g.  Select the oversize ramp signal from the television signal
        generator.

h.  ADJUST - A1R38 (Power Supply board) for a geometry error of < 1%
        (+/- 1 IRE).  NOTE: The error is measured by positioning the
        edge of the signal display to the top, bottom, left, and
        right edges of the CRT.

i.  Repeat this entire step at least once, by pressing the F5 key
        (PC), until there is no readjustment necessary.

j.  Enter the Gain menu and select X1.  Clear the menu display.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
CUR:SEL VOLT
CUR:SEL NONE
UIMENU:CRTADJUST DISP
SWEEP:TIMING TWOLINE
PRE:STORE FACTORY}

{END}

{TITLE:11:INTENSITY SETUPS}

{INST_STATE:
PRE:RE FACTORY
MENU CRT}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Be careful to change only the WFM 601i
        settings and controls called out in this step.  This step
        overwrites the Factory Preset settings stored in the Preset
        menu, and exiting before completion may cause the instrument
        to be incorrectly calibrated.

b.  Adjust INTENSITY (bezel knob) for normal display viewing
        intensity.

c.  Select LIGHTNING display mode and adjust INTENSITY for normal
        display viewing intensity.

d.  Select VECTOR display mode and adjust INTENSITY for normal
        display viewing intensity.

e.  Select PICTURE display mode and adjust BLACK LEVEL and CONTRAST
        for a normal picture display.

f.  Select EYE display mode and adjust INTENSITY for normal display
        viewing intensity.

g.  Select WAVEFORM display mode.

h.  Enter the Line Select menu and verify that 1H is selected. 

i.  Enter the CRT menu.  Adjust INTENSITY and FOCUS for the best
        display.

j.  Enter the Line Select menu and select 15H.

k.  Enter the CRT menu.  Adjust INTENSITY and FOCUS for the best
        display.

l.  Select VECTOR display mode and repeat steps h.-j. NOTE: Do not
        adjust FOCUS when repeating steps h.-j.

m.  Select EYE display mode and repeat steps h.-j. NOTE: Do not
        adjust FOCUS when repeating steps h.-j.

n  Select LIGHTNING display mode and repeat steps h.-j. NOTE: Do not
        adjust FOCUS when repeating steps h.-j.

o.  Enter the Line Select menu, select 1H, then exit the Line Select
        menu.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
LINES:FIELD ALL
LINES:DISP H1
DISP:SINGLE WFM
MENU CLEAR
PRE:STORE FACTORY}

{END}

{TITLE:11:POST READOUT OFFSET AND GAIN}

{INST_STATE:
PRE:RE FACTORY
ROTEST ON}

{SETUP:
a.  Leave any signal connections as they are.}

{ADJUSTMENTS:
CAL:READ:VO    VERT OFFSET
CAL:READ:VG    VERT GAIN
CAL:READ:HO    HORIZ OFFSET
CAL:READ:HG    HORIZ GAIN}

{PROCEDURE:

a.  Verify that the trace rotation is set correctly, then enter the
        CRT menu and adjust INTENSITY to minimum.  
        NOTE: The trace rotation is set by entering the CRT menu,
        selecting TRACE, then adjusting the TRACE ROTATE control.

b.  ADJUST - VERT OFFSET and VERT GAIN (PC) to position the upper 
        cross hair on the 0.7 V graticule line, and position the
        bottom three cross hairs on the 0 V graticule line
        (baseline). See Figure 5-12.

c.  ADJUST - HORIZ OFFSET and HORIZ GAIN (PC) to align the top cross
        hair to the center mark on the 0.7 V graticule and the
        bottom cross hairs to the 10 us, center, and 110 us marks on
        the graticule baseline.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:WAVEFORM VERTICAL GAIN OFFSET}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING ONEL
GAIN:W_V_STATE X10
CAL:WFM:X10VG 0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:WFM:X10VG    X10 V GAIN}

{ASSIGN:
CAL:WFM:X10VG   CAL:WFM:X0VG}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Performing this adjustment requires that the
        VERTICAL X1, and the VERTICAL X5 AND X10 GAIN steps are
        performed before exiting the adjustment procedures.  If they
        are not adjusted, the instrument vertical gain will not be
        within specification.

b.  ADJUST - X10 V GAIN (PC) to reduce the waveform to a horizontal
        line.

c.  Select ASSIGN (PC) and press RETURN.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
CAL:WFM:X10VG 500}

{END}

{TITLE:11:WAVEFORM HORIZONTAL GAIN OFFSET}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING ONEL
CAL:WFM:X1HG 0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:WFM:X1HG    X1 H GAIN}

{ASSIGN:
CAL:WFM:X1HG   CAL:WFM:X0HG}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Performing this adjustment requires that the
        TIMING CURSORS AND HORIZONTAL GAIN step be performed before
        exiting the adjustment procedures.  If it is not adjusted,
        the instrument horizontal gain will not be within
        specification.

b.  ADJUST - X1 H GAIN (PC) to reduce the waveform to a vertical
        line.

c.  Select ASSIGN (PC) and press RETURN.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
CAL:WFM:X1HG 450}

{END}

{TITLE:11:TIMING CURSORS AND HORIZONTAL GAIN}

{INST_STATE:
PRE:RE FACTORY
CUR:SEL TIME
TC:ONE 530
TC:TWO 3030}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:WFM:X1HG  X1 H GAIN}

{PROCEDURE:

a.  Position the TIME1 cursor (bezel knob) to the 10us graticule
        mark and the TIME2 cursor for a 100.0 uS readout.

b.  ADJUST - X1 H GAIN (PC) for exactly 10 major divisions between
        the two timing cursors.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:CALIBRATOR TIMING}

{INST_STATE:
PRE:RE FACTORY
CALS:EN ON}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:WFM:LINE2  2 LINE TIMING
CAL:WFM:X10HG  X10 H GAIN
CAL:WFM:LINE1  1 LINE TIMING}

{PROCEDURE:

a.  ADJUST - 2 LINE TIMING (PC) for one cycle every major division.

b.  Turn on the MAG (front panel), and then select X10 H GAIN (PC).

c.  ADJUST - X10 H GAIN (PC) for one cycle every ten major
        divisions.

d.  Turn off the MAG, and then select 1 LINE sweep (front panel).

e.  Select 1 LINE TIMING (PC).

f.  ADJUST - 1 LINE TIMING (PC) for one cycle every two major
        divisions.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:1 LINE MAG TIMING}

{INST_STATE:
PRE:RE FACTORY
IN:CHAN CH2
SWEEP:TIMING ONEL
SWEEP:MAG ON}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 2.5 MHz bowtie signal.}

{ADJUSTMENTS:
CAL:WFM:X25HG  X25 H GAIN}

{PROCEDURE:

a.  ADJUST - X25 H GAIN (PC) for one cycle every two major
        divisions.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:NTSC FIELD SWEEP}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING ONEF}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Set the generator for NTSC output.}

{ADJUSTMENTS:
CAL:WFM:NTSC1F    NTSC 1 F TIMING
CAL:WFM:NTSC2F    NTSC 2 F TIMING}

{PROCEDURE:

a.  ADJUST - NTSC 1 F TIMING (PC) for a sweep length of 12 major
        divisions +/- 0.5 minor division, as measured on the
        baseline.

b.  Select 2 FIELD sweep (front panel), and NTSC 2 F TIMING (PC).

c.  ADJUST - NTSC 2 F TIMING (PC) for a sweep length of 12 major
        divisions +/- 0.5 minor division, as measured on the
        baseline.

d.  Return the generator output standard to PAL.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:PAL FIELD SWEEP}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING ONEF}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Set the generator for PAL output.}

{ADJUSTMENTS:
CAL:WFM:PAL1F    PAL 1 F TIMING
CAL:WFM:PAL2F    PAL 2 F TIMING}

{PROCEDURE:

a.  ADJUST - PAL 1 F TIMING (PC) for a sweep length of 12 major
        divisions +/- 0.5 minor division, as measured on the
        baseline.

b.  Select 2 FIELD sweep (front panel), and NTSC 2 F TIMING (PC).

c.  ADJUST - PAL 2 F TIMING (PC) for a sweep length of 12 major
        divisions +/- 0.5 minor division, as measured on the
        baseline.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:HORIZONTAL MAGNIFIER REGISTRATION}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING TWOF}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:WFM:HMAG_REG    H MAG REG}

{PROCEDURE:

a.  Horizontally enter the vertical interval portion of the signal
        on the CRT center graticule.

b.  Turn on the MAG (front panel).

c.  ADJUST - H MAG REG (PC) to center the vertical interval back
        onto the CRT center graticule.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:21:Y/G MONITOR OUT DIGITAL GAIN}

{INST_STATE:
PRE:RE FACTORY
SER:MON YPBPR
SER:AL:MONGA OFF}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect a 75 ohm cable from the Y/G monitor output to the
        oscilloscope input.  Do not terminate.

d.  Set the oscilloscope for 200 mV/div., and 10 us/div.}

{ADJUSTMENTS:
CAL:DIG:YG    Y GAIN}

{PROCEDURE:

a.  ADJUST - Y GAIN (PC) for exactly 1.4 V of display from the
        signal baseline to the 100% white level on the oscilloscope.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:41:DIGITAL Y/G OFFSET}

{INST_STATE:
PRE:RE FACTORY}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect the jumper cable adapter from A7J300 (Component board)
        to the oscilloscope with a 75 ohm feed-through terminator.

d.  Set the oscilloscope for 50 mV/div, and 10 us/div.}

{ADJUSTMENTS:
CAL:DIG:YO   Y OFFSET}

{PROCEDURE:

a.  Set the ground reference on the oscilloscope to a graticule
        line.

b.  ADJUST - Y OFFSET (PC) so that the signal baseline is at 0 V on
        the oscilloscope.

c.  Remove the jumper adapter cable.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:WAVEFORM VERTICAL X1 GAIN}

{INST_STATE:
PRE:RE FACTORY}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:WFM:X1VG   X1 V GAIN}

{PROCEDURE:

a.  ADJUST - X1 V GAIN (PC) for signal amplitude of 700 mV.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:LOW PASS FILTER}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING ONEL
FILT LP
MENU FILT}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bars signal.}

{PROCEDURE:

a.  ADJUST - A3L5 and A3L6 (Main board) for best transients.

b.  Set the generator signal output to the multiburst signal.

c.  ADJUST - C131 (Main board) to null the second packet 
        from the right.

d.  ADJUST - A3L5 and A3L6 (Main board) for best transients
        on the leading edge of the white bar.

e.  Enter the Gain menu and select X5.

f.  Repeat steps c and d for best transients and a null in the last 
        two packets of less than 4 mV (1 minor).

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:PB & PR OFFSETS AND GAIN}

{INST_STATE:
PRE:RE FACTORY}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:DIG:PBO   PB OFFSET
CAL:DIG:PBG   PB GAIN
CAL:DIG:PRO   PR OFFSET
CAL:DIG:PRG   PR GAIN}

{PROCEDURE:

a.  NOTE: Before proceeding, check that trace rotation has been set,
        and that the Y channel is set to the graticule baseline.

b.  Select PARADE display mode (front panel) and select CH1, CH2,
        and CH3.

c.  ADJUST - PB OFFSET (PC) to set the maximum level of the CH2
        signal to the 0.7 V graticule line.

d.  Select PB GAIN (PC).

e.  ADJUST - PB GAIN (PC) so that the amplitude of the CH2 signal is
        700 mV.

f.  Select PR OFFSET (PC).

g.  ADJUST - PR OFFSET (PC) to set the maximum level of the CH3
        signal to the 0.7 V graticule line.

h.  Select PR GAIN (PC).

i.  ADJUST - PR GAIN (PC) so that the amplitude of the CH3 signal is
        700 mV.

j.  Enter the Gain menu and select X5.

k.  CHECK - that the offset and gain of the CH2 and CH3 signal
        displays matches that of the CH1 display.  
        Repeat steps c. - i. until the gains and offsets match.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:RGB OFFSETS AND GAIN}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE PAR
IN:CHAN CH1,CH2,CH3
GAIN:W_V_STATE X5}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:DIG:RO        R OFFSET
CAL:DIG:GO        G OFFSET
CAL:DIG:BO        B OFFSET
CAL:WFM:RGBGAIN   RGB GAIN}

{PROCEDURE:

a.  Position the CH1 signal baseline to the graticule baseline.
        NOTE: Do not move the VERT POS control again during this
        step.

b.  Enter the Configure menu.  Select WFM/VEC, and then select
        WFM AS RGB.

c.  Press the CLEAR MENU button to clear the menu display.

d.  ADJUST - R OFFSET (PC) to set the CH1 signal baseline back to
        the graticule baseline.

e.  Select G OFFSET (PC).

f.  ADJUST - G OFFSET (PC) to set the CH2 signal baseline back to
        the graticule baseline.

g.  Select B OFFSET (PC).

h.  ADJUST - B OFFSET (PC) to set the CH3 signal baseline back to
        the graticule baseline.

i.  Enter the Gain menu and select X1.

j.  Select RGB GAIN (PC).

k.  ADJUST - RGB GAIN (PC) for signal amplitude of 
        700 mV +/- 3% (21 mV or 1 minor division).

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VERTICAL X5 AND X10 GAIN}

{INST_STATE:
PRE:RE FACTORY
GAIN:W_V_STATE X5
MENU GAIN}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 5-step staircase signal.}

{ADJUSTMENTS:
CAL:WFM:X5VG   X5 V GAIN
CAL:WFM:X10VG  X10 V GAIN}

{PROCEDURE:

a.  Position the signal baseline to the graticule baseline.

b.  ADJUST - X5 V GAIN (PC) so the amplitude of the first step from
        the signal baseline is 140 mV (7 major divisions).

c.  Select CH2 on and CH1 off on the WFM 601i.

d.  From the Gain menu select X10 and then position the signal
        baseline to the graticule baseline.

e.  Select X10 V GAIN (PC).

f.  ADJUST - X10 V GAIN (PC) so the amplitude of the first step from
        the signal baseline is 70 mV (7 major divisions).  
        NOTE: Use the VERT POS control to keep the signal baseline
        on the graticule baseline while adjusting.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VERTICAL MAG REGISTRATION}

{INST_STATE:
PRE:RE FACTORY}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 5-step staircase signal.}

{ADJUSTMENTS:
CAL:WFM:X5VP   X5 V POS
CAL:WFM:X10VP  X10 V POS}

{PROCEDURE:

a.  Position the signal baseline to the graticule baseline.

b.  Enter the Gain menu and select X5.

c.  ADJUST - X5 V POS (PC) to set the signal baseline on the
        graticule baseline.

d.  Select X10 from the Gain menu, and then select X10 V POS (PC).

e.  Adjust X10 V POS (PC) to set the signal baseline on the
        graticule baseline.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:PB & PR ZERO OFFSETS}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE PAR
GAIN:W_V_STATE X5
IN:CHAN CH1,CH2,CH3
IN:PBPROFFS MV_0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 5-step staircase signal.}

{ADJUSTMENTS:
CAL:DIG:PBZO   PB ZERO OFFSET
CAL:DIG:PRZO   PR ZERO OFFSET}

{PROCEDURE:

a.  Position the CH1 signal baseline to the graticule baseline.

b.  ADJUST - PB ZERO OFFSET (PC) to position the CH2 baseline on the
        graticule baseline.

c.  Select PR ZERO OFFSET (PC).

d.  ADJUST - PR ZERO OFFSET (PC) to position the CH3 baseline on the
        graticule baseline.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:ADJUST BLANKING LEVEL}

{INST_STATE:
PRE:RE FACTORY
IN:PBPROFFS MV_0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect a 75 ohm cable from the Pb/B monitor output to the
        oscilloscope through a 75 ohm feed-through terminator.

d.  Connect a 75 ohm cable from the Y/G monitor output to the
        oscilloscope external trigger input.

e.  Set the oscilloscope for 50 mV/div., 5 ms/div., and external
        trigger.}

{ADJUSTMENTS:
CAL:DIG:BLANKZLEV    ZERO OFF BLANK LEV
CAL:DIG:BLANKLEV     350 OFF BLANK LEV}

{PROCEDURE:

a.  Horizontally position the vertical interval portion of the
        signal to the center of the oscilloscope graticule.

b.  Select X10 mag on the oscilloscope and center the vertical
        interval.

c.  ADJUST - ZERO OFF BLANK LEVEL (PC) so that the blanking level
        of the vertical interval is zero volts (no vertical offset
        in the vertical interval).  See the "Adjusting the Vertical
        Interval Blanking Level Offset" figure in the Adjustment
        Procedure section of the Service Manual.

d.  Enter the Configure menu.  Select WFM/VEC and then select PBPR
        OFFSET 350 mV.

e.  Select 350 OFF BLANK LEVEL (PC).

f.  ADJUST - 350 OFF BLANK LEVEL (PC) so that the blanking level on
        the vertical interval is zero volts (no vertical offset).

g.  Turn off the X10 mag on the oscilloscope.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:GAMUT LIMIT}

{INST_STATE:
PRE:RE FACTORY
SERIAL:ALARM:MONGAMUT ALARM}

{ADJUSTMENTS:
CAL:GA:P   GAMUT PLUS
CAL:GA:M   GAMUT MINUS}

{SETUP:
No setup instructions.}

{PROCEDURE:

====================================================================
|                               NOTE                               |
|  This Gamut Limit procedure consists of two separate adjustment  |
|  procedures.  If your TSG 422 generator has a software version   |
|  of 2.2 or greater perform Part I. For earlier versions of       |
|  software perform Part II.                                       |
====================================================================

PART I

a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Connect a 75 ohm cable to the Y/G MON OUT BNC connector
        of the WFM 601i rear panel. Connect the other end of the 
        BNC cable to the CH2 input of the oscilloscope through a
        75 ohm feedthrough terminator.

c.  Set the following controls on the oscilloscope:
        Trigger Mode       Ch 2
        Display Mode       Ch 2
        Volts/Div          100 mV
        Bandwidth          Full
        Coupling           DC
        Sweep              10 us

d.  Select the gamut limit test signal from the television
        generator.

e.  Adjust the scopes trigger level for a locked display.

f.  Adjust the scopes vertical position control to view the top
        of the waveform.

g.  ADJUST - GAMUT PLUS (PC) so that the positive strobe
        is flashing at the center tick mark of the test signal. 
        The Adjustment Procedure section of the Service Manual
        includes a figure of this display.

h.  Adjust the scopes vertical position control to view the bottom 
        of the waveform.

i.  ADJUST - GAMUT minus (PC) so that the negative strobe
        is flashing at the center tick mark of the test signal. 

           Press the F3 function key to proceed to the next step.













====================================================================
|                               NOTE                               |
|  Perform the following steps only if your TSG 422 has a software |
|  version less than 2.2.                                          |
====================================================================

PART II

a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Select the oversized ramp signal from the television
        generator.Turn off the B-Y and R-Y channels.

c.  Connect a 75 ohm cable from the Y/G monitor output to the
        oscilloscope through a 75 ohm feed-through terminator.

d.  Set the oscilloscope for 100 mV/Div., and 10 us/div.

e.  Position the oscilloscope display to view the top of the ramp.

f.  ADJUST - GAMUT PLUS (PC), if necessary, to view the gamut limit
        pulse. The Adjustment Procedure section of the Service
        Manual includes a figure of this display.

g.  ADJUST - GAMUT PLUS (PC) to make the gamut limit pulse just
        disappear.

h.  Select X1 Adj. Size (F8 key on the PC).

i.  ADJUST - GAMUT PLUS (PC) slowly the other way to make the pulse
        just barely visible, and then press the PC key two more
        times (the gamut limit pulse will brighten).

j.  Position the oscilloscope display to view the bottom of the
        ramp.

k.  Select X10 Adj. Size (F9 key on the PC).

l.  Select GAMUT MINUS (PC).

m.  ADJUST - GAMUT MINUS (PC) if necessary to view the gamut limit
        pulse. See Figure 5-14.

n.  ADJUST - GAMUT MINUS (PC) to make the gamut limit pulse just
        disappear.

o.  Select X1 Adj. Size (F8 key on the PC).

p.  ADJUST - GAMUT MINUS (PC) slowly the other way to make the pulse
        just barely visible, and then press the PC key two more
        times (the gamut limit pulse will brighten).

q.  Turn on the B-Y and R-Y channels on the television signal
        generator.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:MON OUT DIGITAL Y GAIN}

{INST_STATE:
SER:DISP YPBPR
PRE:RE FACTORY
SER:MON YPBPR}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect a 75 ohm cable from the Y/G monitor output to the
        oscilloscope through a 75 ohm feed-through terminator.

d.  Set the oscilloscope for 100 mV/div., 10 us/div.}

{PROCEDURE:

a.  CHECK - that the amplitude of the sync pulse is 300 mV +/- 30 mV
        (1.5 minor divisions) on the oscilloscope.

b.  CHECK - that the amplitude of the signal from the baseline to
        the top is 700 mV +/- 21 mV (1 minor division).

c.  Reference the oscilloscope ground to the center of the
        graticule. Select 50 mV/div., and DC coupling. 

d.  CHECK - that the signal baseline is within +/- 20 mV (2 minor
        divisions) of the ground reference.

e.  Repeat steps b. - d. for the Pb/B and Pr/R monitor outputs,
        checking for 700 mV p-p.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:MON OUT GBR GAIN}

{INST_STATE:
PRE:RE FACTORY
SER:MON GBR}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).

c.  Connect a 75 ohm cable from the Y/G monitor output to the
        oscilloscope through a 75 ohm feed-through terminator.

d.  Set the oscilloscope for 100 mV/div., 10 us/div.}

{PROCEDURE:

a.  CHECK - that the amplitude of the sync pulse is 300 mV +/- 30 mV
        (1.5 minor divisions).

b.  CHECK - that the amplitude of the signal from the baseline to
        the top is 700 mV +/- 21 mV (1 minor division).

c.  Reference the oscilloscope ground to the center of the
        graticule. Select 50 mV/div., and DC coupling. 

d.  CHECK - that the signal baseline is within +/- 20 mV (2 minor
        divisions) of the ground reference.

e.  Repeat steps b. - d. for the Pb/B and Pr/R monitor outputs.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VOLTAGE CURSORS}

{INST_STATE:
PRE:RE FACTORY
CUR:SEL VOLT}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:VC:GAIN    V CURSOR GAIN}

{PROCEDURE:

a.  Position the VOLT1 cursor (Bezel knob) to the top of the CH1
        display.

b.  Position the VOLT2 cursor (Bezel knob) to the bottom of the CH1
        display.

c.  Enter the Gain menu and select X5 gain.

d.  Readjust the cursors to the top and bottom of the signal.

e.  ADJUST - V CURSOR GAIN (PC) for a readout of 700 mV.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:CALIBRATOR AMPLITUDE}

{INST_STATE:
PRE:RE FACTORY
CALS:EN ON}

{SETUP:
a.  Select the 100% color bars without level reference signal.}

{ADJUSTMENTS:
CAL:OSC:SQ    CAL AMP}

{PROCEDURE:

a.  ADJUST - CAL AMP (PC) for display amplitude of 700 mV.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:FREQUENCY RESPONSE}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING ONEL}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% sweep signal.

c.  Connect the jumper cable adapter from the oscilloscope to A7J300
        (Component board) using a 75 ohm feed-through terminator.

d.  Set the oscilloscope for 100 mV/div., 10 us/div., and the input
        bandwidth to full.}

{PROCEDURE:

a.  ADJUST - A7R312 (Component board) for flat response as viewed on
        the oscilloscope.
        NOTE: The response should not vary by more than one minor
        division.

b.  Remove the jumper cable adapter.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:ON-SCREEN FREQUENCY RESPONSE}

{INST_STATE:
PRE:RE FACTORY
IN:CHAN CH1, CH2, CH3
DISP:SINGLE PAR}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% sweep signal.}

{PROCEDURE:

a.  Midrange A3L9 (Main board).

b.  ADJUST - A3R183 and A3C91 (Main board) for the flat response
        +/- 2% on the Y (left) display.

c.  Enter the Gain menu and select X10.

d.  CHECK - that the top and bottom edges of the sweep waveform vary
        less than 10 mV (1 major division) while being positioned
        vertically over the entire 1 V graticule area.
        See the "Checking the On-screen Frequency Response" figure
        in the Adjustment Procedure section of the Service manual.
        If this check does not pass, then readjust A3L9, A3R183, and
        A3C91.

e.  Select X5 gain.

f.  ADJUST - A7R410 (Component board) for the flat response
        +/- 2% on the Pb (middle) display.

g.  ADJUST - A7R510 (Component board) for the flat response +/- 2%
        on the Pr (right) display.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:81:EYE GAIN & OFFSETS}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE EY
EY:DISP EYE10}

{ADJUSTMENTS:
CAL:EY:VG    EYE GAIN
CAL:EY:EQV    EQ EYE GAIN
CAL:EY:X5VP    X5 POSITION
CAL:EY:X10VP    X10 POSITION}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the oscilloscope for 2V/Div and 100 ms/Div (timebase).}

{PROCEDURE:

a.  Connect the scope probe to pin 6 of A5U1 (Deserializer board).

b.  Adjust A5L3 for maximum DC level.

c.  ADJUST - EYE GAIN (PC) for 800 mV of signal.

d.  Select EQ EYE display mode.

e.  ADJUST - EQ EYE GAIN (PC) for 600 mV of signal on the 
        WFM 601i.

f.  Select EYE display mode from the front panel.

g.  Set the signal baseline to the -.1 volt graticule line with the
        VERT POS control.

h.  Enter the GAIN menu and select X5 gain.

i.  ADJUST - X5 POSITION (PC) to set the baseline on the -.1 volt
        graticule line.

j.  Select X10 gain.

k.  ADJUST - X10 POSITION (PC) to set the baseline on the -.1 volt
        graticule line.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:81:EYE BANDWIDTH}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE EY
CAL:EYE:OVH}

{SETUP:
a.  Connect the SG5030 Leveling Head via a 50 to 75 ohm min.
        loss pad to the WFM 601i SER A input.

b.  Terminate the loopthrough with a high-frequency terminator.}

{PROCEDURE:

a.  Set the SG5030 to the following settings:
        Output                  ON
        Frequency           10 MHz
        Amplitude           .632 V

b.  ADJUST - the amplitude of the SG5030 for a 400 mV display
        on the WFM 601i.

c.  Enter the Gain menu, select X5 gain and turn the Variable Gain
        on.

d.  ADJUST - the Variable Gain for 1 volt (10 div) of display on the
        WFM 601i. 
        NOTE: You may have to use the Vertical Position control to
        get the signal on-screen.

e.  Set the SG5030 frequency to 270 MHz.

f.  ADJUST - C52 on the Eye Pattern board for a 900 mV (9 div)
        (-1 dB 10% down) display.

g.  Set the WFM 601i Gain to X1, and turn the Variable Gain off.

h.  Disconnect the Leveling Head from the WFM 601i.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:81:EYE TIMING (Horizontal Deflection Factor)}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE EY
TCURSORS:ONE 1000
TCURSORS:TWO 2850}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.}

{ADJUSTMENTS:
CAL:EYE:OVH EYE TIMING}

{PROCEDURE:

a.  Let the display settle for 1 minute.

b  ADJUST - (with the Arrow keys) for two cycles of eye pattern
        to 7.4 divisions; use the horizontal and vertical controls
        to position the signal over the graticule. 

c.  Enter the Cursor menu and select the Time cursors.

d.  CHECK - with the timing cursors for two cycles at
        7.400 ns +/- 3% (7.178-7.622).

e.  Press the MAG button on.

f.  CHECK - with the timing cursors for one cycle at
        3.700 ns +/- 3% (3.589-3.811).

g.  Press the MAG button off.

h.  Enter the Configure menu. From the bezel, enter the Eye Pattern
        menu and select the 10 EYE display. 

i.  Enter the Cursor menu.

j.  CHECK - with the timing cursors for six cycles
        at 22.2 ns +/- 3% (21.534-22.866).

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:81:EYE JITTER}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE EY
EYE:JITTER J10
CURSOR:SELECT TIME
TCURSORS:ONE 2280
TCURSORS:TWO 2330}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.}

{PROCEDURE:

a.  Use the TRACK knob to center the cursors on any eye crossover.

b.  Use the Horizontal Position control to place the cursors at
        center screen.

c.  Press the MAG button on the WFM 601i.

d.  Allow for a one minute settling period

e.  CHECK - that the eye display has less than 200 ps of jitter.
        NOTE: Either the cursors or 2 horizontal minors can be used
        to determine if the jitter is within the specification.

f.  Enter the Configure menu. From the bezel, enter the Eye Pattern
        menu and select the 10 EYE display. 
        Press the CLEAR MENU button.

g.  Allow for a one minute settling period

h.  CHECK - using 2 horizontal minors, for less than 200 ps of
        jitter.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:GBR OUTPUT RESPONSE}

{INST_STATE:
PRE:RE FACTORY
SWEEP:TIMING ONEL
SER:MON GBR}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% sweep signal.
        Turn off the B-Y and R-Y channels.

c.  Connect a 75 ohm cable from the Y/G monitor output to the
        oscilloscope through a 75 ohm feed-through terminator.

d.  Set the oscilloscope for 100 mV/div., and 10 us/div.}

{PROCEDURE:

a.  ADJUST - A7C711 (Component board) for the flat response +/- 3%
        on the oscilloscope display.

b.  Move the cable from the Y/G to the Pb/B monitor output.

c.  ADJUST - A7C721 (Component board) for the flat response +/- 3%
        on the oscilloscope display.

d.  Move the cable from the Pb/B to the Pr/R monitor output.

e.  ADJUST - A7C731 (Component board) for the flat response +/- 3%
        on the oscilloscope display.

f.  Turn on the B-Y and R-Y channels on the television signal
        generator.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:BOWTIE ADJUSTMENTS}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE BOW}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 2.5 MHz bowtie signal.}

{PROCEDURE:

a.  ADJUST - A7C308 (Component board) from one end of its adjustment
        range to the other while watching the position of the null
        point on the right bowtie display.  Then adjust A7C308 to
        position the null point to the horizontal center of the
        range provided by the adjustment of A7C308.

b.  ADJUST - A7C407 (Component board) to position the null point of
        the left bowtie display to the center display marker.
        See the "Adjusting the Bowtie Display" Figure in the
        Adjustment Procedure section of the Service manual.5-16.
        NOTE: If there is not enough range in A7C407, readjust
        A7C308, and repeat this step.

c.  ADJUST - A7C507 (Component board) to center the null point of
        the right bowtie display on the center marker.
        NOTE: If there is not enough range in A7C507, readjust
        A7C308, then repeat steps b. - c.

d.  Turn on the MAG.

e.  Check - that the null point of both the left and right bowtie
        displays are centered on their respective center markers.
        Readjust A7C407 and A7C507 as necessary to center the bowtie
        null points on their center markers.

f.  Turn off the MAG.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:BOWTIE GAIN}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE BOW}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).  Turn off the B-Y and R-Y
        channels.}

{ADJUSTMENTS:
CAL:BOW:GAIN   BOWTIE GAIN}

{PROCEDURE:

a.  ADJUST - BOWTIE GAIN (PC) for signal amplitude of 700 mV.

b.  Turn on the B-Y and R-Y channels on the television signal
        generator.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VECTOR TIMING}

{INST_STATE:
PRE:RE FACTORY}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the multiburst signal.}

{PROCEDURE:

a.  Verify the multiburst signal and then select VECTOR display
        mode.

b.  ADJUST - A7C136 and A7C133 (Component board) for a straight and
        smooth line with no eye opening on the vector display.

c.  NOTE: If this adjustment cannot be made, check the dress of the
        crt wires.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:COMPONENT VERTICAL OFFSET}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE LTNG
CAL:LTNG:VERT:X1G 0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:LTNG:VERT:X1G   X1 V GAIN}

{ASSIGN:
CAL:LTNG:VERT:X1G   CAL:LTNG:VERT:X0G}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Performing this adjustment requires that the
        COMPONENT VERTICAL GAIN step is performed before exiting the
        adjustment procedures.  If it is not adjusted, the
        instrument component vertical gain will not be within
        specification.

b.  ADJUST - X1 V GAIN (PC) to reduce the display to a horizontal
        line.

c.  Select ASSIGN (PC) and then press RETURN.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
CAL:LTNG:VERT:X1G 370}

{END}

{TITLE:11:COMPONENT VERTICAL GAIN}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE LTNG
DISP:INTENSITY:READOUT -2047}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:LTNG:VERT:X1G   X1 V GAIN}

{PROCEDURE:

a.  ADJUST - X1 V GAIN (PC) for a 1000 mV signal display.

b.  Turn on the MAG, then enter the Gain menu and select X5.

c.  CHECK - each dot for no overshoot tails.

d.  NOTE:  If the dots have overshoot tails, check the dress of the
        crt wires and restart the adjustment procedures from the
        Vector Timing step.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
DISP:INTENSITY:READOUT 0}

{END}

{TITLE:11:COMPONENT HORIZONTAL OFFSET}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE LTNG
CAL:LTNG:HORZ:X1G 0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:LTNG:HORZ:X1G   X1 H GAIN}

{ASSIGN:
CAL:LTNG:HORZ:X1G   CAL:LTNG:HORZ:X0G}

{PROCEDURE:

a.  NOTE: Performing this adjustment requires that the COMPONENT
        HORIZONTAL GAIN step is performed before exiting the
        adjustment procedures. If it is not adjusted, the instrument
        component horizontal gain will not be within specification.

b.  ADJUST - X1 H GAIN (PC) to reduce the display to a vertical
        line.

c.  Select ASSIGN (PC) and then press RETURN.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
CAL:LTNG:HORZ:X1G 1000}

{END}

{TITLE:11:COMPONENT HORIZONTAL GAIN}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE LTNG}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:LTNG:HORZ:X1G   X1 H GAIN}

{PROCEDURE:

a.  ADJUST - X1 H GAIN (PC) for a display 8 major divisions wide
        (measured from the lower C and lower R dots.
        NOTE: Turn the readout intensity down to clearly see the
        waveform.

b.  Turn on the MAG.

c.  CHECK - the dots for no overshoot tails.

d.  NOTE:  If the dots have overshoot tails, check the dress of the
        crt wires and restart the adjustment procedures from the
        Vector Timing step.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VECTOR VARIABLE GAIN OFFSETS}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE VEC
GAIN:VEC:VAR:STATE ON}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:DIG:HCLAMP   H CLAMP
CAL:DIG:VCLAMP   V CLAMP}

{PROCEDURE:

a.  Adjust VECTOR GAIN (bezel knob) to minimum gain.

b.  Note the position of the vector center dot.

c.  Adjust VECTOR GAIN (bezel knob) to maximum gain.

d.  ADJUST - H CLAMP and V CLAMP (PC) to reposition the center dot
        to the minimum gain reference point.

e.  Repeat steps a. - d. until there is minimal shift of the center
        dot as the VECTOR GAIN control is adjusted from minimum to
        maximum.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:ELECTRONIC GRATICULE ADJUSTMENTS}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE LTNG
SER:MON YPBPR}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:LTNG:GRAT:XO    X OFFSET
CAL:LTNG:GRAT:YO    Y OFFSET
CAL:GRAT:XG         X GAIN
CAL:GRAT:YG         Y GAIN}

{PROCEDURE:

a.  ADJUST - X OFFSET and Y OFFSET (PC) to position the center dot
        in the center of the graticule center box.

b.  Select X GAIN (PC).

c.  ADJUST - X GAIN (PC) for 8 major divisions of display from the
        left edge of the lower C graticule box to the left edge of
        the lower R graticule box.  The Adjustment Procedure section
        of the Service Manual includes a figure of this display.

d.  Select Y GAIN (PC).

e.  ADJUST - Y GAIN (PC) for 1000 mV of display between the bottom
        dots of the upper and lower 100% graticule dots.
        NOTE: Turn down the signal intensity to clearly view the
        graticule.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VECTOR VERTICAL OFFSET}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE VEC
CAL:VEC:VERT:GAINX1 0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:VEC:VERT:GAINX1   X1 V GAIN}

{ASSIGN:
CAL:VEC:VERT:GAINX1   CAL:VEC:VERT:GAIN0}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Performing this adjustment requires that the
        VECTOR VERTICAL GAIN step be performed before exiting the
        adjustment procedures. If it is not adjusted, the instrument
        vector vertical gain will not be within specification.

b.  ADJUST - X1 V GAIN (PC) to reduce the display to a horizontal
        line.

c.  Select ASSIGN (PC) and then press RETURN.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
CAL:VEC:VERT:GAINX1 750}

{END}

{TITLE:11:VECTOR VERTICAL GAIN}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE VEC}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:VEC:VERT:GAINX1   X1 V GAIN}

{PROCEDURE:

a.  ADJUST - X1 V GAIN (PC) for 1000 mV of display (measured from
        the R dot to the Cy dot.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VECTOR HORIZONTAL OFFSET}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE VEC
CAL:VEC:HORZ:GAINX1 0}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:VEC:HORZ:GAINX1   X1 H GAIN}

{ASSIGN:
CAL:VEC:HORZ:GAINX1   CAL:VEC:HORZ:GAIN0}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Performing this adjustment requires that the
        VECTOR HORIZONTAL GAIN step be performed before exiting the
        adjustment procedures.  If it is not adjusted, the
        instrument vector horizontal gain will not be within
        specification.

b.  ADJUST - X1 H GAIN (PC) to reduce the display to a vertical
        line.

c.  Select ASSIGN (PC) and then press RETURN.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
CAL:VEC:HORZ:GAINX1 1000}

{END}

{TITLE:11:VECTOR HORIZONTAL GAIN}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE VEC}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:VEC:HORZ:GAINX1   X1 H GAIN}

{PROCEDURE:

a.  ADJUST - X1 H GAIN (PC) for 8 major divisions of display
        (measured from the YL dot to the B dot.
        NOTE: Turn down the readout intensity to clearly view the
        waveform.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:VECTOR GRATICULE OFFSETS}

{INST_STATE:
PRE:RE FACTORY
DISPLAY:SINGLE VEC}

8{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:VEC:GRAT:XO     X OFFSET
CAL:VEC:GRAT:YO     Y OFFSET}

{PROCEDURE:

a.  ADJUST - X OFFSET and Y OFFSET (PC) to place the vector center
        dot in the center of the graticule center box.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:DIAMOND GAIN}

{INST_STATE:
PRE:RE FACTORY
LTNG:GRAT DIA
DISP:SINGLE LTNG}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{ADJUSTMENTS:
CAL:LTNG:VERT:DIA    V GAIN
CAL:LTNG:HORZ:DIA    H GAIN}

{PROCEDURE:

a.  ADJUST - V GAIN and H GAIN (PC) to overlay the signal on the
        graticule.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:DIAMOND DISPLAY PHASE}

{INST_STATE:
PRE:RE FACTORY
LTNG:GRAT DIA
DISP:SINGLE LTNG
SWEEP:MAG ON}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Select the 100% color bar signal WITH level reference from
        the television signal generator.}

{PROCEDURE:

a.  ADJUST - A7C74 (Component board) for balanced minimum eye
        openings on the Diamond display.  The Adjustment Procedure
        section of the Service Manual includes a figure of this
        display.

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:11:NTSC PICTURE MONITOR}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE PIX
SER:AL:SCREENGA OFF
MENU CRT}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).  Set the generator for NTSC
        output.}

{ADJUSTMENTS:
CAL:PIX:NTSCVS   V SWEEP
CAL:PIX:HG       H GAIN}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Be careful to change only the WFM 601i
        settings and controls called out in this step.  This step
        overwrites the Factory Preset settings stored in the Preset
        menu, and exiting this step before completing it may cause
        the instrument to be incorrectly calibrated.

b.  ADJUST - BLACK LEVEL and CONTRAST (bezel knobs) for a clear
        display of seven distinct bars.

c.  Press the CLEAR MENU button to clear the menu.

d.  Select APL on the television signal generator.

e.  ADJUST - V SWEEP (PC) and the VERT POS control to just set the
        picture to the CRT display edges.

f.  Select H GAIN (PC).

g.  ADJUST - H GAIN (PC) and the HORIZ POS control to just set the
        picture to the CRT display edges.

h.  Turn off the APL on the television signal generator and set its
        output for PAL.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
DISP:SINGLE WFM
PRE:STORE FACTORY}

{END}

{TITLE:11:PAL PICTURE MONITOR}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE PIX
SER:AL:SCREENGA OFF
MENU CRT}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).  Set the generator for PAL
        output.}

{ADJUSTMENTS:
CAL:PIX:PALVS   V SWEEP}

{PROCEDURE:

a.  WARNING: Completely perform this step before proceeding to
        another step.  Be careful to change only the WFM 601i
        settings and controls called out in this step.  This step
        overwrites the Factory Preset settings stored in the Preset
        menu, and exiting this step before completing it may cause
        the instrument to be incorrectly calibrated.

b.  ADJUST - BLACK LEVEL and CONTRAST (bezel knobs) for a clear
        display of seven distinct bars.

c.  Press the CLEAR MENU button to clear the menu.

d.  Select APL on the television signal generator.

e.  ADJUST - V SWEEP (PC) and the VERT POS control to just set the
        picture to the CRT display edges.

f.  Turn off the APL on the television signal generator.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
DISP:SINGLE WFM
PRE:STORE FACTORY}

{END}

{TITLE:11:PICTURE INTERFERENCE}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE PIX}

{SETUP:
a.  Connect the serial digital output of the television signal
        generator to the WFM 601i SER A input.  Terminate the
        loopthrough with a 75 ohm high-frequency terminator.

b.  Set the generator signal output to the 100% color bar signal
        (without level reference).}

{PROCEDURE:

a.  ADJUST - A1R42 (Power Supply board) for minimum noise
        interference (best noticed in the dark bars).

           Press the F3 function key to proceed to the next step.}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 1}

{INST_STATE:
PRE:RE FACTORY
IN:CHAN CH1,CH2,CH3
DISP:SINGLE PAR}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  No user action necessary.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET1}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 2}

{INST_STATE:
PRE:RE FACTORY
IN:CHAN CH1,CH2,CH3
DISPLAY:SINGLE PAR}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  No user action necessary.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET2}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 3}

{INST_STATE:
PRE:RE FACTORY
IN:CHAN CH1,CH2,CH3
DISPLAY:SINGLE PAR}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  No user action necessary.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET3}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 4}

{INST_STATE:
PRE:RE FACTORY
DISP:SINGLE WFM
IN:CHAN CH1,CH2,CH3
SWEEP:TIMING ONELINE}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  No user action necessary.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET4}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 5}

{INST_STATE:
PRE:RE PRESET4
DISP:SINGLE LTNG
LTNG:GRATICULE DIAMOND}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  No user action necessary.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET5}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 6}

{INST_STATE:
PRE:RE PRESET1
SERIAL:EAVSAV PASS
INPUT:CHANNEL CH1}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  Center the display, and then press the MAG button to show
        the EAV and SAV signals.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET6}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 7}

{INST_STATE:
PRE:RE PRESET1
DISPLAY:SINGLE EY}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  No user action necessary.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET7}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 8}

{INST_STATE:
PRE:RE PRESET1
CUR:SEL VOLT_TIME
CUR:CONTROL VOLT
DISPLAY:SINGLE EY
MENU CURSOR}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  No user action necessary.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET8}

{END}

{TITLE:00:STORE FACTORY DEFAULT PRESET 9}

{INST_STATE:
PRE:RE PRESET1
DISP:SINGLE EY
CURSOR:SELECT TIME
TC:ONE 2004
TC:TWO 2129}

{SETUP:
a.  Leave any signal connections as they are.}

{PROCEDURE:

a.  Use the TRACK bezel control to center the cursors 
        over the eye crossover.

b.  Center the display and press the MAG button.

           Press the F3 function key to proceed to the next step.}

{EXIT_STATE:
PRE:STORE PRESET9}

{END}}

